/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.redis.clients.jedis.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import net.impactdev.impactor.relocations.redis.clients.jedis.exceptions.JedisConnectionException;
import net.impactdev.impactor.relocations.redis.clients.jedis.util.DoublePrecision;

public class RedisInputStream
extends FilterInputStream {
    private static final int INPUT_BUFFER_SIZE = Integer.parseInt(System.getProperty("jedis.bufferSize.input", System.getProperty("jedis.bufferSize", "8192")));
    protected final byte[] buf;
    protected int count;
    protected int limit;

    public RedisInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
    }

    public RedisInputStream(InputStream in) {
        this(in, INPUT_BUFFER_SIZE);
    }

    public byte readByte() throws JedisConnectionException {
        this.ensureFill();
        return this.buf[this.count++];
    }

    private void ensureCrLf() {
        byte[] buf = this.buf;
        this.ensureFill();
        if (buf[this.count++] == 13) {
            this.ensureFill();
            if (buf[this.count++] == 10) {
                return;
            }
        }
        throw new JedisConnectionException("Unexpected character!");
    }

    public String readLine() {
        StringBuilder sb = new StringBuilder();
        while (true) {
            this.ensureFill();
            byte b = this.buf[this.count++];
            if (b == 13) {
                this.ensureFill();
                byte c = this.buf[this.count++];
                if (c == 10) break;
                sb.append((char)b);
                sb.append((char)c);
                continue;
            }
            sb.append((char)b);
        }
        String reply = sb.toString();
        if (reply.length() == 0) {
            throw new JedisConnectionException("It seems like server has closed the connection.");
        }
        return reply;
    }

    public byte[] readLineBytes() {
        this.ensureFill();
        int pos = this.count;
        byte[] buf = this.buf;
        while (true) {
            if (pos == this.limit) {
                return this.readLineBytesSlowly();
            }
            if (buf[pos++] != 13) continue;
            if (pos == this.limit) {
                return this.readLineBytesSlowly();
            }
            if (buf[pos++] == 10) break;
        }
        int N = pos - this.count - 2;
        byte[] line = new byte[N];
        System.arraycopy(buf, this.count, line, 0, N);
        this.count = pos;
        return line;
    }

    private byte[] readLineBytesSlowly() {
        ByteArrayOutputStream bout = null;
        while (true) {
            this.ensureFill();
            byte b = this.buf[this.count++];
            if (b == 13) {
                this.ensureFill();
                byte c = this.buf[this.count++];
                if (c == 10) break;
                if (bout == null) {
                    bout = new ByteArrayOutputStream(16);
                }
                bout.write(b);
                bout.write(c);
                continue;
            }
            if (bout == null) {
                bout = new ByteArrayOutputStream(16);
            }
            bout.write(b);
        }
        return bout == null ? new byte[]{} : bout.toByteArray();
    }

    public Object readNullCrLf() {
        this.ensureCrLf();
        return null;
    }

    public boolean readBooleanCrLf() {
        byte[] buf = this.buf;
        this.ensureFill();
        byte b = buf[this.count++];
        this.ensureCrLf();
        switch (b) {
            case 116: {
                return true;
            }
            case 102: {
                return false;
            }
        }
        throw new JedisConnectionException("Unexpected character!");
    }

    public int readIntCrLf() {
        return (int)this.readLongCrLf();
    }

    public long readLongCrLf() {
        boolean isNeg;
        byte[] buf = this.buf;
        this.ensureFill();
        boolean bl = isNeg = buf[this.count] == 45;
        if (isNeg) {
            ++this.count;
        }
        long value = 0L;
        while (true) {
            this.ensureFill();
            byte b = buf[this.count++];
            if (b == 13) {
                this.ensureFill();
                if (buf[this.count++] == 10) break;
                throw new JedisConnectionException("Unexpected character!");
            }
            value = value * 10L + (long)b - 48L;
        }
        return isNeg ? -value : value;
    }

    public double readDoubleCrLf() {
        return DoublePrecision.parseFloatingPointNumber(this.readLine());
    }

    public BigInteger readBigIntegerCrLf() {
        return new BigInteger(this.readLine());
    }

    @Override
    public int read(byte[] b, int off, int len) throws JedisConnectionException {
        this.ensureFill();
        int length = Math.min(this.limit - this.count, len);
        System.arraycopy(this.buf, this.count, b, off, length);
        this.count += length;
        return length;
    }

    private void ensureFill() throws JedisConnectionException {
        if (this.count >= this.limit) {
            try {
                this.limit = this.in.read(this.buf);
                this.count = 0;
                if (this.limit == -1) {
                    throw new JedisConnectionException("Unexpected end of stream.");
                }
            }
            catch (IOException e) {
                throw new JedisConnectionException(e);
            }
        }
    }
}

